//----------------------------------------------------------------------------//
//- CamConst.pas -------------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Enhlt globale Konstanten                                                  //
//----------------------------------------------------------------------------//

unit CamConst;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Messages;

//------------------------------------------------------------------------------

const
  c_dCasVersion                  = 1.00;

// Allgemeine Zahl-Konstanten
const
  c_iKeineAngabe                 = 0;
  c_iArtikelCodeLaenge           = 6;
  c_iAnzahlFTasten               = 12;
  c_iMaxStringLaenge             = 25;
  c_iDialogResultNeuerBogen      = 10;
  c_iDialogResultBogenFortfahren = 11;
  c_iDailogResultAnzahlEingeben  = 12;

// Allgemeine String-Konstanten
  c_sAppName                     = 'CAS';
  c_sZwischenTotal               = 'Zwischentotal';
  c_sTotal                       = 'Total';
  c_sBoerseStarten               = 'Brse starten...';
  c_sBoerseBeenden               = 'Brse beenden...';

// Alle gltigen Zahlen als Charakter
const
  c_stCharZahlen: Set of Char    = ['0'..'9'];

// Etikettenbogen-Konstanten
const
  c_iAnzahlBogenEtiketten        = 24;

// Grosse Schriftart
const
  c_iGrosseSchriftgroesse        = 30;
  c_iGrosseSchriftart            = 'Arial';

// Meldungen
const
  c_sMeldungVerlassen            = 'Wollen Sie das Programm verlassen?';
  c_sMeldungEingabeErforderlich  = 'Das Feld "%s" muss abgefllt werden';
  c_sMeldungKeineSelektion       = 'Bitte whlen Sie einen Eintrag aus';
  c_sMeldungPasswortUngueltig    = 'Ungltiges Passwort';
  c_sMeldungPasswortUngleich     = 'Passwortbesttigung stimmt nicht mit dem neuen Passwort berein';
  c_sMeldungEtikettenDrucken     = 'Wollen Sie fr die (den) eben erfassten Artikel Etiketten ausdrucken?';
  c_sMeldungInitialenExistieren  = 'Die eingegebenen Initialen existieren bereits';
  c_sMeldungKeinAnbieter         = 'Kein Anbieter selektiert';
  c_sMeldungBoerseBeenden        = 'Wollen sie die Brse wirklich beenden?';
  c_sMeldungArtikelUnbekannt     = 'Artikelnummer unbekannt!';
  c_sMeldungArtikelVerkauft      = 'Artikel wurde bereits verkauft';
  c_sMeldungVerkaufNichtAbgeschl = 'Der Verkauf ist noch nicht abgeschlossen, die Quittung kann noch nicht gedruckt werden';
  c_sMeldungBoerseAktiv          = 'Es wurde bereits eine Brse gestartet. Sie knnen erst eine neue starten, wenn diese beendet wurde!';
  c_sMeldungBoerseNichtAktiv     = 'Es wurde keine Brse gestartet!';
  c_sMeldungBoerseGeladen        = 'Die Brse "%s", die am %s gestartet wurde, wird geladen';
  c_sMeldungProgrammNichtBeenden = 'Solange ein Verkauf nicht abgeschlossen ist, kann das Programm nicht beendet werden';
  c_sMeldungKeineArtikelAnzeige  = 'Da sich Artikel auf eine bestimmte Brse beziehen, knnen keine Artikel angezeigt werden, solange keine Brse aktiv ist -> Bitte starten Sie erst eine Brse';
  c_sMeldungKeineArtikelErfasst  = 'Es wurden keine Artikel erfasst';
  c_sMeldungAbschlussDrucken     = 'Sollen die Abschlussdaten ausgedruckt werden? -> Das nachtrgliche Ausdrucken ist nicht mglich. Wollen sie spter Ausdrucken, whlen Sie "Abbrechen" und schliessen die Brse erneut ab.';
  c_sMeldungKeinAbschluss        = 'Die Brse wurde nicht abgeschlossen!';
  c_sMeldungDatenbankpfadFehler  = 'Fehler beim Anlegen des Datenbankpfades';

// Panelpositionen in der Statusbar
const
  c_iStatusPanelStatus           = 0;
  c_iStatusPanelDateTime         = 1;

// Anzeigestatus des Panels
const
  c_iStatusBereit           = 0;
  c_iStatusVerkauf          = 1;
  c_iStatusKeineBoerse      = 2;

// Statusbar Meldungen
const
  c_sStatusBereit                = 'Bereit fr den nchsten Kunden';
  c_sStatusVerkauf               = 'Verkauf luft';
  c_sStatusKeineBoerse           = 'Keine Brse gestartet';

// Konstanten die angeben, wie ein Dialog gefnet wird
const
  c_iModusDefault                = 0;
  c_iModusNeu                    = 1;
  c_iModusEdit                   = 2;
  c_iModusCopy                   = 3;
  c_iModusDelete                 = 4;

// DialogTitel
const
  c_sAnbieterNeu                 = 'Anbieter erfassen';
  c_sAnbieterBearbeiten          = 'Anbieter bearbeiten';
  c_sAnbieterKopieren            = 'Anbieter kopieren';

  c_sArtikelNeu                  = 'Artikel erfassen';
  c_sArtikelBearbeiten           = 'Artikel bearbeiten';

// Beschriftung der F-Tasten
const
  c_sF_QuittungDrucken           = 'Quittung drucken';
  c_sF_ArtikelNeu                = 'Artikel Neu/Bearbeiten';
  c_sF_Start                     = 'Brse starten';
  c_sF_Beenden                   = 'Brse beenden';
  c_sF_AnbieterNeu               = c_sAnbieterNeu;

// Stings im Zusammenhang mit Brsendaten
const
  c_sBoerseName                  = '&Name der Brse';
  c_sBoerseDatum                 = '&Datum der Brse';
  c_sBoerseAbgabenProzent        = 'A&bgaben in %';
  c_sBoerseAbgabenBetrag         = 'Ab&gaben als Betrag';
  c_sBoerseBoersendaten          = 'Brsendaten';
  c_sBoerseAbgaben               = 'Abgaben';

// Farben
const
  c_clFTasten                    = $00C8C8C8;

// Sortierung der PersonenListe
const
  c_iByInitialen                 = 0;
  c_iByVorname                   = 1;
  c_iByName                      = 2;
  c_iByPlz                       = 3;
  c_iByOrt                       = 4;

// Windows-Messages
const
  wm_UpdateFrmAnbieterUebersicht = wm_App + 10;

// Strichcode Steuer-Konstanten
const
  c_iOrderVerkaufBeenden         = 900001;
  c_iOrderQuittungDrucken        = 900002;
  c_iOrderAnbieterErfassen       = 900003;
  c_iOrderArtikelErfassen        = 900004;

//-Registry Konstanten ---------------------------------------------------------

const
  c_sStandardKey                 = 'SOFTWARE';
  c_sFirmaKey                    = 'Sieber';
  c_sProgrammKey                 = 'CAS';
  c_sEintragFehlendeEtiketten    = 'FehlendeEtiketten';
  c_sEintragInitialenDrucken     = 'InitialenDrucken';
  c_sEintragPassword             = 'Passwort';

//-Datenbank Konstanten --------------------------------------------------------

// DatenbankPfad
  c_sDbPfad                      = 'C:\Cas';

// Datenbank-Namen
  c_sDbPersonen                  = 'Personen.db';
  c_sDbAnbieter                  = 'Anbieter.db';
  c_sDbArtikel                   = 'Artikel.db';
  c_sDbBoersenInfo               = 'BoersenInfo.db';

// Personen.db
  c_sPersonenInitialen           = 'Initialen';
  c_sPersonenName                = 'Name';
  c_sPersonenOrt                 = 'Ort';
  c_sPersonenPersonenNummer      = 'PersonenNummer';
  c_sPersonenPlz                 = 'Plz';
  c_sPersonenStrasse             = 'Strasse';
  c_sPersonenVorname             = 'Vorname';

// BoersenInfo
  c_sBoersenAbgabeBetrag         = 'AbgabeBetrag';
  c_sBoersenAbgabeProzent        = 'AbgabeProzent'; 
  c_sBoersenBoersenDatum         = 'BoersenDatum';
  c_sBoersenAbschlussDatum       = 'BoersenAbschlussDatum';
  c_sBoersenBoersenNummer        = 'BoersenNummer';
  c_sBoersenTitel                = 'Titel';
  c_sBoerseActive                = 'BoerseActive';

// Artikel.db
  c_sArtikelArtikelNummer        = 'ArtikelNummer';
  c_sArtikelBeschreibung         = 'Beschreibung';
  c_sArtikelBoersenNummer        = c_sBoersenBoersenNummer;
  c_sArtikelPreis                = 'Preis';
  c_sArtikelVerkauft             = 'Verkauft';

// Anbieter.db
  c_sAnbieterArtikelNummer       = c_sArtikelArtikelNummer;
  c_sAnbieterPersonenNummer      = c_sPersonenPersonenNummer;

implementation

//------------------------------------------------------------------------------

end. // CamConst
